<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Password Reset</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">

<style>
*{box-sizing:border-box}
body{
  margin:0;
  font-family:'Poppins',sans-serif;
  background:linear-gradient(135deg,#6a11cb,#8e2de2);
  min-height:100vh;
  overflow:hidden;
}

/* PARTICLE */
canvas{
  position:fixed;
  inset:0;
  z-index:1;
  pointer-events:none;
}

/* PAGE */
.page{
  position:relative;
  z-index:2;
  min-height:100vh;
  display:flex;
  align-items:center;
  justify-content:center;
  padding:40px;
}

/* WRAPPER */
.wrapper{
  width:100%;
  max-width:1000px;
  background:#fff;
  border-radius:22px;
  display:flex;
  box-shadow:0 50px 100px rgba(0,0,0,.35);
  overflow:hidden;
}

/* LEFT */
.left{
  flex:1.2;
  background:#f4f1ff;
  display:flex;
  align-items:center;
  justify-content:center;
  padding:40px;
}

.illustration{
  width:100%;
  max-width:380px;
  animation:float 6s ease-in-out infinite;
}
@keyframes float{
  0%,100%{transform:translateY(0)}
  50%{transform:translateY(-14px)}
}

/* RIGHT */
.right{
  flex:1;
  background:linear-gradient(135deg,#7b4ce6,#5f2eea);
  padding:50px 40px;
  color:#fff;
  display:flex;
  flex-direction:column;
  justify-content:center;
}

/* CARD */
.card{
  background:rgba(255,255,255,.18);
  backdrop-filter:blur(20px);
  border-radius:20px;
  padding:40px;
  box-shadow:0 30px 80px rgba(0,0,0,.25);
}

h2{
  margin-bottom:10px;
  font-weight:600;
  text-align:center;
}

.desc{
  font-size:14px;
  opacity:.85;
  text-align:center;
  margin-bottom:22px;
}

/* INPUT */
.input{
  width:100%;
  height:46px;
  border-radius:14px;
  border:none;
  padding:0 15px;
  background:rgba(255,255,255,.25);
  color:#fff;
  font-size:14px;
}

.input::placeholder{color:#e6ddff}

.input:focus{
  outline:none;
  box-shadow:0 0 0 3px rgba(255,204,0,.45);
}

/* BUTTON */
button{
  width:100%;
  height:48px;
  border:none;
  border-radius:14px;
  background:#ffcc00;
  color:#000;
  font-weight:600;
  cursor:pointer;
  transition:.3s;
  margin-top:18px;
}
button:hover{transform:translateY(-2px)}

.links{
  text-align:center;
  margin-top:18px;
  font-size:14px;
}
.links a{
  color:#ffcc00;
  text-decoration:none;
}

/* ===== MOBILE FIX ===== */
@media(max-width:900px){
  .wrapper{flex-direction:column}
  .left{display:none}
}

@media(max-width:480px){
  body{overflow:auto}

  .page{
    padding:20px 12px;
    align-items:flex-start;
  }

  .wrapper{
    border-radius:18px;
  }

  .right{
    padding:22px 16px;
  }

  .card{
    padding:22px 16px;
    border-radius:18px;
  }

  h2{
    font-size:22px;
  }

  .desc{
    font-size:13px;
  }

  .input{
    height:44px;
    border-radius:12px;
  }

  button{
    height:46px;
    font-size:15px;
  }

  .links{
    font-size:13px;
  }
}
</style>
</head>

<body>

<canvas id="fx"></canvas>

<div class="page">
  <div class="wrapper">

    <!-- LEFT -->
    <div class="left">
      <img src="<?= base_url('public/assets/img/Password-Reset.png') ?>"
           class="illustration"
           alt="Password Reset">
    </div>

    <!-- RIGHT -->
    <div class="right">
      <div class="card">

        <h2>Password Reset</h2>
        <div class="desc">
          Enter your email address and we’ll send you a reset link.
        </div>

        <?= form_open(url_to('password-reset'),
          'class="actionForm" data-redirect="user"') ?>

        <input class="input" type="email" name="email"
          placeholder="Email Address" required autofocus>

        <button>Send Reset Link</button>

        <?= form_close(); ?>

        <div class="links">
          Remembered password?
          <a href="<?= base_url('sign-in') ?>">Sign In</a>
        </div>

      </div>
    </div>

  </div>
</div>

<script>
/* PARTICLE TOUCH */
const c=document.getElementById("fx"),x=c.getContext("2d");
let w,h,p=[];
function resize(){w=c.width=innerWidth;h=c.height=innerHeight}
resize();addEventListener("resize",resize);

function add(x0,y0){p.push({x:x0,y:y0,l:60})}
addEventListener("mousemove",e=>add(e.x,e.y));
addEventListener("touchmove",e=>{
 let t=e.touches[0];add(t.clientX,t.clientY)
});

function draw(){
 x.clearRect(0,0,w,h);
 p.forEach((a,i)=>{
  a.l--;
  p.slice(i+1).forEach(b=>{
   let d=Math.hypot(a.x-b.x,a.y-b.y);
   if(d<120){
    x.strokeStyle=`rgba(255,255,255,${.15*(1-d/120)})`;
    x.beginPath();x.moveTo(a.x,a.y);x.lineTo(b.x,b.y);x.stroke();
   }
  });
 });
 p=p.filter(a=>a.l>0);
 requestAnimationFrame(draw);
}
draw();
</script>

</body>
</html>
